"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const ByteArray_1 = require("../internal/ByteArray");
const Native = require("../../../Native");
class CreateCallLinkCredentialPresentation extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.CreateCallLinkCredentialPresentation_CheckValidContents);
    }
    verify(roomId, serverParams, callLinkParams, now = new Date()) {
        Native.CreateCallLinkCredentialPresentation_Verify(this.contents, roomId, Math.floor(now.getTime() / 1000), serverParams.contents, callLinkParams.contents);
    }
}
exports.default = CreateCallLinkCredentialPresentation;
//# sourceMappingURL=CreateCallLinkCredentialPresentation.js.map